<%@ Page Title="TBI Instruments - Test Instrument Questions / Answers" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="InstrumentTestEntry.aspx.cs" Inherits="TBI_InstrumentTestEntry" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">

    <style type="text/css">
            .breadcrumbInstrument {
                background-color:#6B1424;
                border-bottom:1px solid #000;
                color:#FFF;
                font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
                font-variant:small-caps;
                font-weight:700;
                letter-spacing:1px;
                margin: 2px 0 2px 0;
                padding:8px 25px 5px 10px;
            }
            
    </style>
        
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:HiddenField ID="DisplayMode" runat="server" Value=""/>
    <asp:Panel ID="PanelQuestionsAnswers" runat="server">
            <div class="breadcrumbInstrument">
                <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Questions / Answers"></asp:Label> 
            </div>
            <br />
            <div style="margin:10px">
                
                <asp:Panel ID="PanelPatient"
                      GroupingText="Patient&nbsp;&nbsp;" runat="server">
                <br />
                &nbsp;&nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel"></asp:Label>
                <br />
                <br />
                </asp:Panel>
            </div>
            <div style="margin:12px">
                <asp:Label ID="LabelforLabelInstrumentType" runat="server" 
                    AssociatedControlID="LabelInstrumentType" SkinID="DataLabel">Instrument Type:</asp:Label>
                <asp:Label ID="LabelInstrumentType" runat="server" SkinID="DataLabel">TBI Test</asp:Label>
            </div>
            <hr style="margin:12px;size:1" />
            <asp:Label ID="LabelforTextBoxChiefComplaint" AssociatedControlID="TextBoxChiefComplaint" runat="server" CssClass="firstLevelQuestion">
            A. Chief Complaint:
            </asp:Label>
            <br />
            <asp:TextBox ID="TextBoxChiefComplaint" runat="server" 
                TextMode="MultiLine" Rows="5" Width="90%" 
                CssClass="firstLevelAnswer"></asp:TextBox>
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxHistoryPresentIllness" AssociatedControlID="TextBoxHistoryPresentIllness" runat="server" CssClass="firstLevelQuestion">
            B. History of Present Illness, or Interval History since last visit:
            </asp:Label>
            <br />
            <asp:TextBox ID="TextBoxHistoryPresentIllness" runat="server" 
                TextMode="MultiLine" Rows="5" Width="90%"   
                CssClass="firstLevelAnswer"></asp:TextBox>
            <br /><br />
            <asp:Panel ID="PanelChangeMaritalStatus" Width="500px"  CssClass="firstLevelAnswer"
              GroupingText="1. Change in Marital Status:&nbsp;&nbsp;" runat="server">
                <asp:RadioButtonList ID="RadioButtonListChangeInMaritalStatus" runat="server" RepeatDirection="Vertical" RepeatColumns="2">
                    <asp:ListItem Value="4712">No</asp:ListItem>    
                    <asp:ListItem Value="4713">Yes, Married or Partnered</asp:ListItem>    
                    <asp:ListItem Value="4714">Yes, Divorced or separated</asp:ListItem>    
                    <asp:ListItem Value="4715">Yes, Widowed</asp:ListItem>    
                </asp:RadioButtonList>
            </asp:Panel>
            <br /><br />
	        <asp:Panel ID="PanelHighestEducationalLevel" Width="500px"  CssClass="firstLevelAnswer"
              GroupingText="2. Highest educational level achieved:&nbsp;&nbsp;" runat="server">
                <asp:RadioButtonList ID="RadioButtonListHighestEducationalLevel" runat="server" RepeatDirection="Vertical">
                    <asp:ListItem Value="4717">Less than high school</asp:ListItem>    
                    <asp:ListItem Value="4718">High school or equivalent</asp:ListItem>    
                    <asp:ListItem Value="4719">Some college, associates degree, or technical degree</asp:ListItem>    
                    <asp:ListItem Value="4720">College graduate (baccalaureate)</asp:ListItem>    
                    <asp:ListItem Value="4721">Post baccalaureate</asp:ListItem>    
                </asp:RadioButtonList>
            </asp:Panel>	
	        <br /><br />
            <asp:Panel ID="PanelCurrentSchool" Width="500px"  CssClass="secondLevelQuestion"
              GroupingText="2-A. Current school or training status:&nbsp;&nbsp;" runat="server">
                <asp:RadioButtonList ID="RadioButtonListCurrentSchool" runat="server" RepeatDirection="Vertical">
                    <asp:ListItem Value="4723">Full time Student/Trainee</asp:ListItem> 
                    <asp:ListItem Value="4724">Part time Student/Trainee</asp:ListItem> 
                    <asp:ListItem Value="4725">Not attending school or trainee program</asp:ListItem> 
                </asp:RadioButtonList>
            </asp:Panel>	
            <br /><br />
            <asp:Panel ID="PanelCurrentEmploymentStatus" Width="500px"  CssClass="firstLevelQuestion"
              GroupingText="3. Current employment status:&nbsp;&nbsp;" runat="server">
                <asp:RadioButtonList ID="RadioButtonListCurrentEmploymentStatus" runat="server" RepeatDirection="Vertical">
                    <asp:ListItem Value="4727">Unemployed looking for work</asp:ListItem> 
                    <asp:ListItem Value="4728">Unemployed not looking for work</asp:ListItem> 
                    <asp:ListItem Value="4729">Working part-time</asp:ListItem> 
                    <asp:ListItem Value="4730">Working full-time</asp:ListItem> 
                    <asp:ListItem Value="4731">Student</asp:ListItem> 
                    <asp:ListItem Value="4732">Volunteer</asp:ListItem> 
                    <asp:ListItem Value="4733">Homemaker</asp:ListItem> 
                </asp:RadioButtonList>
            </asp:Panel>	
            <br /><br />
            <asp:Panel ID="PanelExperiencedHeadInjury" Width="500px"  CssClass="firstLevelQuestion"
              GroupingText="4. Experienced head injury since prior evaluation?&nbsp;&nbsp;" runat="server">
                <asp:RadioButtonList ID="RadioButtonListExperiencedHeadInjury" runat="server" RepeatDirection="Vertical">
                    <asp:ListItem Value="4735">Yes</asp:ListItem> 
                    <asp:ListItem Value="4736">No</asp:ListItem> 
                </asp:RadioButtonList>
                <br />
                <br />
                <asp:Label ID="LabelMonthOfRecentHeadInjury" AssociatedControlID="DropDownListMonthOfRecentHeadInjury" runat="server" CssClass="secondLevelQuestion">
                4-A. Month of most recent head injury:
                </asp:Label>
                <asp:DropDownList ID="DropDownListMonthOfRecentHeadInjury" runat="server" CssClass="secondLevelAnswer">
                    <asp:ListItem Value="">--Select a Value--</asp:ListItem>
                    <asp:ListItem Value="1">1</asp:ListItem>
                    <asp:ListItem Value="2">2</asp:ListItem>
                    <asp:ListItem Value="3">3</asp:ListItem>
                    <asp:ListItem Value="4">4</asp:ListItem>
                    <asp:ListItem Value="5">5</asp:ListItem>
                    <asp:ListItem Value="6">6</asp:ListItem>
                    <asp:ListItem Value="7">7</asp:ListItem>
                    <asp:ListItem Value="8">8</asp:ListItem>
                    <asp:ListItem Value="9">9</asp:ListItem>
                    <asp:ListItem Value="10">10</asp:ListItem>
                    <asp:ListItem Value="11">11</asp:ListItem>
                    <asp:ListItem Value="12">12</asp:ListItem>
                </asp:DropDownList>  
                <br />
                <br />
                <asp:Label ID="LabelforTextBoxYearHeadInjury" AssociatedControlID="TextBoxYearHeadInjury" runat="server" CssClass="secondLevelQuestion">
                4-B. Year of most recent head injury:
                </asp:Label>
                &nbsp;&nbsp;
                <asp:TextBox ID="TextBoxYearHeadInjury" runat="server" 
                Width="122px"   
                CssClass="firstLevelAnswer"></asp:TextBox>
            </asp:Panel>	
            <br />
            <br />
            <br />
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:Button ID="ButtonSave" UseSubmitBehavior = "true" Width="200px" 
            runat="server" Text="Save Draft" ToolTip="Save Draft" CausesValidation="true" 
            style="cursor:hand" ValidationGroup="OnSave" />
        <br />
        <br />
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:Button ID="ButtonPrepareNote" UseSubmitBehavior = "true" Width="200px" 
            runat="server" Text="Save and Prepare Note" ToolTip="Save and Prepare Note" CausesValidation="true" 
            style="cursor:hand" ValidationGroup="OnSave" onclick="ButtonPrepareNote_Click" />
        </asp:Panel>
        <asp:Panel ID="PanelPreparedNote" runat="server">
            <div class="breadcrumbInstrument">
                <asp:Label ID="Label1" runat="server" Text="TBI Instruments > Instrument Questions / Answers > Note Prepared"></asp:Label> 
            </div>
            <br />
            <div style="margin:10px">
                
                <asp:Panel ID="Panel2"
                      GroupingText="Patient&nbsp;&nbsp;" runat="server">
                <br />
                &nbsp;&nbsp;<asp:Label ID="LabelPatient2" runat="server" SkinID="DataLabel"></asp:Label>
                <br />
                <br />
                </asp:Panel>
            </div>
            <div style="margin:12px">
                <asp:Label ID="LabelforLabelInstrumentType2" runat="server" 
                    AssociatedControlID="LabelInstrumentType2" SkinID="DataLabel">Instrument Type:</asp:Label>
                <asp:Label ID="LabelInstrumentType2" runat="server" SkinID="DataLabel">TBI Test</asp:Label>
            </div>
            <hr style="margin:12px;size:1" />
            
            <div style="margin:10px">
                <asp:Panel ID="PanelConfirmNote" 
                              GroupingText="Confirm Note&nbsp;&nbsp;" runat="server">
                              
                    <asp:Label ID="Label8" runat="server" SkinID="DataLabel">
                    Based on the answers from the previous page, the note content to be submitted is displayed below.
                    <br /><br />
                    Please review the content.  If you need to make changes, click the back button and edit the anwsers.
                    If you confirm the content is correct, click the "Submit Note" button below.
                    <br />
                    <br />
                    Note: once the note is submitted, it will no longer be editable in this tool and updates will need to be done within CPRS.
                    </asp:Label>
                </asp:Panel>
            </div>
            <br />                
            <div style="margin:10px">
            <asp:Label ID="Label5" runat="server" CssClass="firstLevelQuestion">
            A. Chief Complaint:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerChiefComplaint" runat="server" CssClass="firstLevelAnswer"/>
            <br />
            <br />
            
            <asp:Label ID="Label6" runat="server" CssClass="firstLevelQuestion">
            B. History of Present Illness, or Interval History since last visit:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerHistoryIllness" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
            
            <asp:Label ID="Label9" runat="server" CssClass="firstLevelQuestion">
            1. Change in Marital Status:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerMaritalStatus" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
            
            <asp:Label ID="Label3" runat="server" CssClass="firstLevelQuestion">
            2. Highest educational level achieved:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerEducationLevel" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
            
            <asp:Label ID="Label4" runat="server" CssClass="firstLevelQuestion">
            2-A. Current school or training status:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerCurrentSchool" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
            
            <asp:Label ID="Label10" runat="server" CssClass="firstLevelQuestion">
            3. Current employment status:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerEmploymentStatus" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
            
            <asp:Label ID="Label11" runat="server" CssClass="firstLevelQuestion">
            4. Experienced head injury since prior evaluation?
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerExperienceHeadInjury" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
            
            <asp:Label ID="Label12" runat="server" CssClass="firstLevelQuestion">
            4-A. Month of most recent head injury:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerMonthHeadInjury" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
            
            <asp:Label ID="Label7" runat="server" CssClass="firstLevelQuestion">
            4-B. Year of most recent head injury:
            </asp:Label>
            <br />
            <asp:Label ID="LabelAnswerYeadHeadInjury" runat="server" CssClass="firstLevelAnswer"/>
            <br /><br />
         
            <asp:Button ID="ButtonBack" UseSubmitBehavior = "true" Width="200px" 
                runat="server" Text="Back" ToolTip="Back" CausesValidation="true" 
                style="cursor:hand" ValidationGroup="OnSave" onclick="ButtonBack_Click"/>
            <br />
            <br />
            
            <asp:Button ID="ButtonSubmitNote" UseSubmitBehavior = "true" Width="200px" 
                runat="server" Text="Submit Note" ToolTip="Submit Note" CausesValidation="true" 
                style="cursor:hand" ValidationGroup="OnSave" onclick="ButtonSubmitNote_Click" />
            </div>
        </asp:Panel>
        <br />
        <br />
        <br />
</asp:Content>

